/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.entities;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.blocks.ForgeExplosiveBlock;
import com.endertech.minecraft.forge.entities.BlockStateCarrier;
import com.endertech.minecraft.forge.math.GameTime;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FuseEntity
extends BlockStateCarrier {
    private int ticksToExplosion;
    private float explosionSize;
    private EntityLivingBase igniter;

    public FuseEntity(World world) {
        super(world);
    }

    public FuseEntity(World world, BlockPos pos, IBlockState carriedState, CommonTime.Interval ignitionTime, float explosionSize, @Nullable EntityLivingBase igniter) {
        super(world, pos, carriedState);
        this.ticksToExplosion = (int)ignitionTime.in(GameTime.SERVER_TICKS);
        this.explosionSize = explosionSize;
        this.igniter = igniter;
        CommonMath.Angle angle = CommonMath.Angle.random();
        this.field_70159_w = -angle.sin() * 0.02;
        this.field_70181_x = 0.2;
        this.field_70179_y = -angle.cos() * 0.02;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70156_m = true;
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        if (this.isServerSide() && this.ticksToExplosion-- <= 0) {
            this.explode();
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= 0.04;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.98;
            this.field_70181_x *= 0.98;
            this.field_70179_y *= 0.98;
            if (this.field_70122_E) {
                this.field_70159_w *= 0.7;
                this.field_70179_y *= 0.7;
                this.field_70181_x *= -0.5;
            }
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void explode() {
        ForgeExplosiveBlock explosive = (ForgeExplosiveBlock)this.getCarriedBlockState().func_177230_c();
        Explosion explosion = this.field_70170_p.func_72876_a((Entity)this.getIgniter(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getExplosionSize(), true);
        explosive.doDestruction(this.field_70170_p, this.func_180425_c(), this.getCarriedBlockState(), explosion);
    }

    @Nullable
    public EntityLivingBase getIgniter() {
        return this.igniter;
    }

    public float func_70047_e() {
        return 0.0f;
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a(Tags.TICKS_TO_EXPLOSION.name(), this.ticksToExplosion);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.ticksToExplosion = compound.func_74762_e(Tags.TICKS_TO_EXPLOSION.name());
    }

    public float getExplosionSize() {
        return this.explosionSize;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer
    extends Render<FuseEntity> {
        public Renderer(RenderManager renderManagerIn) {
            super(renderManagerIn);
            this.field_76989_e = 0.5f;
        }

        @Nullable
        protected ResourceLocation getEntityTexture(FuseEntity entity) {
            return TextureMap.field_110575_b;
        }

        public void doRender(FuseEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
            IBlockState state = entity.getCarriedBlockState();
            if (state == null) {
                return;
            }
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
            this.func_180548_c(entity);
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)0.5f);
            blockrendererdispatcher.func_175016_a(state, entity.func_70013_c());
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            if (this.field_188301_f) {
                GlStateManager.func_179142_g();
                GlStateManager.func_187431_e((int)this.func_188298_c(entity));
                blockrendererdispatcher.func_175016_a(state, 1.0f);
                GlStateManager.func_187417_n();
                GlStateManager.func_179119_h();
            }
            GlStateManager.func_179121_F();
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }

        public static class Factory
        implements IRenderFactory<FuseEntity> {
            public Render<? super FuseEntity> createRenderFor(RenderManager manager) {
                return new Renderer(manager);
            }
        }
    }

    private static enum Tags {
        TICKS_TO_EXPLOSION;

    }
}

